unit HotSpot;

interface

uses
 WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
 Menus, ExtCtrls;

type
  THotspot = class(TGraphicControl)
  private
    FColor: TColor;
    FCreated: Boolean;
    FFlashTime: Integer;
    FLineWidth: Integer;
    FShowBox: Boolean;
    FToggle: Boolean;
    FlashTimer: TTimer;
    LeftLine: TShape;
    TopLine: TShape;
    RightLine: TShape;
    BottomLine: TShape;
    procedure Paint; override;
    procedure SetColor(Value: TColor);
    procedure FlashTimerTimer(Sender: TObject);
    procedure SetFlashTime(Value: Integer);
    procedure SetLineWidth(Value: Integer);
    procedure SetShowBox(Value: Boolean);
    procedure UpdateBox;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure SetParent(Value: TWinControl);
  published
    property Align;
    property Color: TColor read FColor write SetColor default clWhite;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FlashTime: Integer read FFlashTime write SetFlashTime;
    property LineWidth: Integer read FLineWidth write SetLineWidth default 3;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property ShowBox: Boolean read FShowBox write SetShowBox default True;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{******************************************************}

constructor THotspot.Create(AOwner: TComponent);
begin
inherited Create(AOwner);
Width := 32;
Height:= 32;
FColor := clWhite;
FToggle := True;
FLineWidth := 3;
FShowBox := True;
FlashTimer := TTimer.Create(Self);
FlashTimer.OnTimer := FlashTimerTimer;
FlashTimer.Enabled := False;
Visible := True;
end;

{******************************************************}

destructor THotspot.Destroy;
begin
inherited Destroy;
end;

{******************************************************}

procedure THotSpot.SetParent(Value: TWinControl);
begin
Parent := Value;
if FCreated then
	begin
	LeftLine.Parent := Value;
	RightLine.Parent := Value;
	TopLine.Parent := Value;
	BottomLine.Parent := Value;
  end;
Invalidate;
end;

{******************************************************}

procedure THotSpot.SetColor(Value: TColor);
begin
FColor := Value;
Invalidate;
end;

{******************************************************}

procedure THotSpot.SetFlashTime(Value: Integer);
begin
FFlashTime := Value;
if FFlashTime >= 100 then
  begin
  FlashTimer.Interval := Value;
  FlashTimer.Enabled := True;
  end
else
  begin
  FFlashTime := 0;
  FlashTimer.Interval := 0;
  FlashTimer.Enabled := False;
  FToggle := True;
  end;
UpdateBox;
end;

{******************************************************}

procedure THotSpot.FlashTimerTimer(Sender: TObject);
begin
FToggle := not FToggle;
UpdateBox;
end;

{******************************************************}

procedure THotSpot.SetLineWidth(Value: Integer);
begin
if Value >= 2 then
  FLineWidth := Value
else
  FLineWidth := 2;
Invalidate;
end;

{******************************************************}

procedure THotSpot.UpdateBox;
{Show/hide the hotspot box}
var
  L, R, T, B, H, W: Integer;
begin
{Create box rectangles if necessary}
if Parent = nil then
	Exit;
if not FCreated then
  begin
  LeftLine := TShape.Create(Self);
  LeftLine.Parent := Parent;
  TopLine := TShape.Create(Self);
  TopLine.Parent := Parent;
  RightLine := TShape.Create(Self);
  RightLine.Parent := Parent;
  BottomLine := TShape.Create(Self);
  BottomLine.Parent := Parent;
  FCreated := True;
  end;
{Get box coordinates}
L := Left - FLineWidth;
R := Left + Width;
T := Top - FLineWidth;
B := Top + Height;
W := Width + (2 * FLineWidth);
H := Height + (2 * FLineWidth);
with LeftLine do
  begin
  if FShowBox or (Brush.Style = bsSolid) then
    begin
    Left := L;
    Top := T;
    Width := FLineWidth;
    Height := H;
    Brush.Color := FColor;
    if FShowBox and FToggle then
      Brush.Style := bsSolid
    else
      Brush.Style := bsClear;
    Pen.Style := psClear;
    end;
  end;
with RightLine do
  begin
  if FShowBox or (Brush.Style = bsSolid) then
    begin
    Left := R;
    Top := T;
    Width := FLineWidth;
    Height := H;
    Brush.Color := FColor;
    if FShowBox and FToggle then
      Brush.Style := bsSolid
    else
      Brush.Style := bsClear;
    Pen.Style := psClear;
    end;
  end;
with TopLine do
  begin
  if FShowBox or (Brush.Style = bsSolid) then
    begin
    Left := L;
    Top := T;
    Width := W;
    Height := FLineWidth;
    Brush.Color := FColor;
    if FShowBox and FToggle then
      Brush.Style := bsSolid
    else
      Brush.Style := bsClear;
    Pen.Style := psClear;
    end;
  end;
with BottomLine do
  begin
  if FShowBox or (Brush.Style = bsSolid) then
    begin
    Left := L;
    Top := B;
    Width := W;
    Height := FLineWidth;
    Brush.Color := FColor;
    if FShowBox and FToggle then
      Brush.Style := bsSolid
    else
      Brush.Style := bsClear;
    Pen.Style := psClear;
    end;
  end;
end;

{******************************************************}

procedure THotSpot.SetShowBox(Value: Boolean);
begin
FShowBox := Value;
UpdateBox;
end;

{******************************************************}

procedure THotspot.Paint;
begin
UpdateBox;
inherited Paint;
end;

{******************************************************}

procedure Register;
begin
RegisterComponents('Samples', [THotspot]);
end;

{******************************************************}

end.
